package com.sap.idm.vds.connector.samplefile.impl;

import java.io.RandomAccessFile;
import java.io.IOException;
import java.io.File;


/**
 * Class dedicated to file modifications.
 * There are two allowed modification types:
 * 		- APPEND -> Adds certain content at the end of the content of the file
 * 		- REPLADE -> Replaces the content of the file by certain content
 * @author I054742
 *
 */
public class FileModify {
	
	/**
	 * Constructor
	 */
	public FileModify () {}
	
	
	/**
	 * Modifies the content of the file which path is 'filePath'.
	 * The modification options are:
	 * 		- APPEND -> Adds 'content' at the end of the content of the file
	 * 		- REPLADE -> Replaces the content of the file by 'content'
	 * @param filePath -> Path of the file to be modified
	 * @param content -> Content
	 * @param option -> Modification option
	 * @param isDNDirectory -> Indicates the type of file according to the DN related with this call
	 * @return -> An integer code indicating if the operation was done successfully or not.
	 * 			  In the case of error the corresponding error code is returned
	 */
	public int modify (String filePath, String content, int option, boolean isDNDirectory) {
		RandomAccessFile fileRA = null;
		try {
			/* If it is expected to make modifications in a directory an error code is returned,
			 * since this is a not allowed operation */
			if (isDNDirectory) {	
				return FileConstants.WRONG_DN_FILE_TYPE;
			}
			File file = new File(filePath);
			/* If the file is not founded it will be indicated by the corresponding error code */
			if (file.exists()==false) {
				return FileConstants.FILE_NOT_FOUND;
			}
			/* This operation is not allowed for a directory */
			if (file.isDirectory()) {
				return FileConstants.WRONG_FILE_TYPE;
			}
			
			/* Makes the modification */
			fileRA = new RandomAccessFile(filePath,"rw");
			FileBasicOperations operations = new FileBasicOperations(fileRA);
			/* Checks the option */
			if (option==FileConstants.REPLACE) operations.clean();
			else if (option==FileConstants.APPEND) {}
			else {
				fileRA.close();
				return FileConstants.INVALID_OPTION;
			}
			
			operations.addAtEnd(content);
			fileRA.close();
			
			return FileConstants.SUCCESS;
		}
		catch (IOException e) {
			try {
				if (fileRA!=null) fileRA.close();
			}
			catch (IOException ioe) {
				return FileConstants.IO_ERROR;
			}
			return FileConstants.IO_ERROR;
		}
	}
}
